﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;

//PathNode is used with the A* pathfinding a represents a singular point/node in the path
public class PathNode
{
    public Vector3Int Position { get; private set; }

    public int GCost { get; set; }
    public int HCost { get; set; }
    public int FCost { get; private set; }

    public PathNode Parent { get; set; }

    public int CalculateFCost()
    {
        FCost = GCost + HCost;
        return FCost;
    }

    public PathNode(Vector3Int position)
    {
        Position = position;
        GCost = int.MaxValue;
        HCost = 0;
        CalculateFCost();
        Parent = null;
    }
}
